

from typing import List


class BaseLanguage:
    def __init__(self, alphabet: List[str]=None) -> None:
        pass

    def in_language(self, input_str: str) -> bool:
        raise NotImplementedError
    
    def counterexample(self, aut):
        raise NotImplementedError
    
    @property
    def alphabet(self):
        return self.ctx.alphabet
    
    @property
    def definition(self):
        return self.ctx.definition()
    
    @property
    def examples(self):
        return self.ctx_cls.examples
    
    @property
    def context_name(self):
        return type(self.ctx).__name__
    
    @property
    def name(self):
        return type(self).__name__

